﻿using Sunny.UI;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using ZSMusic.Model;

namespace ZSMusic.Winform
{
    public partial class FrmUpdate : UIForm
    {
        public static VersionInfo LocalVersionInfo { get; set; }
        public static List<VersionInfo> TargetVervionInfo { get; set; }
        public FrmUpdate()
        {
            InitializeComponent();
        }

        private void FrmUpdate_Load(object sender, EventArgs e)
        {
            txtOld.Text = string.Format("软件版本:{0}\r\n接口版本:{1}\r\n更新时间:{2}\r\n{3}", LocalVersionInfo.UIVersion, LocalVersionInfo.DALVersion, LocalVersionInfo.Time.ToString("yyyy-MM-dd"), LocalVersionInfo.Description);
            StringBuilder sb = new StringBuilder();
            foreach (var item in TargetVervionInfo)
            {
                sb.Append(string.Format("软件版本:{0}\r\n接口版本:{1}\r\n更新时间:{2}\r\n{3}", item.UIVersion, item.DALVersion, item.Time.ToString("yyyy-MM-dd"), item.Description));
                sb.Append("\r\n");
            }
            txtNew.Text = sb.ToString();
        }

        private void uiButton1_Click(object sender, EventArgs e)
        {
            Process.Start("explorer.exe", TargetVervionInfo[0].Url);
        }

    }
}
